
function [sorted, ind] = maxsort(timetraces)

%%% Sorts based on maximum value of each column (cell during the recording)
%%% First cell will have lowest peak,last cell will have highest value
%%% Saves the cells order in "ind" with their initial position in
%%% "timetraces"


%%% FINDS MAX VALUE OF EACH CELL (stored in "maxeach")
ii=0;
maxeach = zeros(1,size(timetraces,2));

for ii=1:size(timetraces,2) %for all the frames
    maxeach(ii) = max(timetraces(:,ii));
end

%%% SORTS "maxeach" AND SAVES SORTED CELLS REFERENCE IN "ind"
%%% CREATES MATRIX CONTAINING SORTED TRACES

[~, ind] = sort(maxeach);
sorted = timetraces(:,ind);

end